/* @copyright 1996, The Regents of the University of California
 * Find a bipartite subgraph with many edges, using a greedy heuristic */

#include <stdio.h>
#include <math.h>
#include "graphtool.h"
 
#define NUM_NODES 2000
#define NUM_EDGES 6000
 
extern int num_edges,num_nodes,directed;
struct node *nodes=NULL;
struct edge *edges=NULL;

struct heapentry
{
   int v;
} vheap[NUM_NODES];

struct vertstruct
{
   int heaploc;  /* 0 if not on heap, which means node is red */
   int redsurplus; /* excess of red nodes over blue nodes; choose
                      node with smallest value to paint red! */
} vdata[NUM_NODES];

int heapcount = 0;

main()
{
 
  int i,v,deg,w,bipcount,worstsurplus;
  struct node *node;
  struct edge *edge, *startedge;

  ar_read_graph(stdin,&nodes,&edges,NUM_NODES,1,NUM_EDGES,1);
  line_buffer(stdout);
  printf("#debug bipartite.dbg\n");
  vertex_edge_lists(&edges[1]);
  for (v = 1; v <= num_nodes; v++) 
  {
    node = &nodes[v];
    edge = startedge = nodes[v].vh;
    deg = 0;
    while (edge != NULL)
    {
      deg++;
      edge = SUCCPP(edge,node);
      if (edge == startedge) edge = NULL;
    }
    vdata[v].redsurplus = -deg;
    /*printf("#nodep %d 3\n",v); /*debug*/
    /*click_message("node %d: surplus = %d\n",v, vdata[v].redsurplus); /*debug*/
    /*printf("#nodep %d -2\n",v); /*debug*/
 
    insertheap(v);
    verifyheap();
  }

  for (i=1; i <= num_nodes/2; i++)
  {
    v = vheap[1].v;
    worstsurplus = vdata[v].redsurplus;
    printf("#nodep %d -1\n",v);
    /*click_message("%d: node %d selected, surplus = %d\n",i,v, vdata[v].redsurplus); /*debug*/
    vheap[1].v = vheap[heapcount--].v;
    siftdown(1);
    vdata[v].heaploc = 0;
    verifyheap();
    node = &nodes[v];
    edge = startedge = nodes[v].vh;
    while (edge != NULL)
    {
      w = OPP_VERTPP(edge,node)->num;
      if (vdata[w].heaploc != 0) /*i.e., if w is still blue */
      {
        vdata[w].redsurplus = vdata[w].redsurplus + 2;
        siftdown(vdata[w].heaploc);
      }
      edge = SUCCPP(edge,node);
      if (edge == startedge) edge = NULL;
    }
    verifyheap();
  }
  for (v = 1,bipcount = 0; v <= num_nodes; v++) 
  {
    node = &nodes[v];
    edge = startedge = nodes[v].vh;
    while (edge != NULL)
    {
      w = OPP_VERTPP(edge,node)->num;
      if ((vdata[v].heaploc == 0)  == (vdata[w].heaploc == 0)) /*if same color*/
      printf("#edge- %d\n",edge->num);
      else bipcount++;
      edge = SUCCPP(edge,node);
      if (edge == startedge) edge = NULL;
    }
  }
  bipcount = bipcount / 2;  /* counted each edge twice */

  click_message("%d out of %d edges remain, worst = %d\n",bipcount,num_edges,
                worstsurplus);
  printf("#nodebug\n");
  flush_pipe(); 
}

insertheap(v)
int v;
{
  int loc;
  loc = ++heapcount;
  siftup(v,loc);
}
 

siftup(v,loc)
int v;
int loc;
{
  int redsurplus;
  int parent;
  char str[100];
  redsurplus = vdata[v].redsurplus;
  parent = loc/2;
  while((loc > 1) && (redsurplus < vdata[vheap[parent].v].redsurplus))
  {
    vheap[loc].v = vheap[parent].v;
    vdata[vheap[loc].v].heaploc = loc;
    loc = parent;
    parent = loc/2;
  }
  vheap[loc].v = v;
  vdata[v].heaploc = loc;
}
 

siftdown(loc)
int loc;
{
  int v,child;
  int redsurplus;
  v = vheap[loc].v;
  redsurplus = vdata[v].redsurplus;
  child = 2 * loc;
  while(child <= heapcount)
  {
    child = ((child < heapcount) &&
             (vdata[vheap[child+1].v].redsurplus < vdata[vheap[child].v].redsurplus))?
            child+1 : child;
    if (redsurplus < vdata[vheap[child].v].redsurplus) break;
    vheap[loc].v = vheap[child].v;
    vdata[vheap[loc].v].heaploc = loc;
    loc = child;
    child = 2 * loc;
  }
  vheap[loc].v = v;
  vdata[vheap[loc].v].heaploc = loc;
}
 
verifyheap()
{
  int i,j;
  int vi, vj;
  for (i=1; i <= heapcount; i++)
  {
    if (vdata[vheap[i].v].heaploc != i)
    {
     click_message("heap loc error: %d %d %d\n",
       i,vheap[i].v,vdata[vheap[i].v].heaploc);
     printf("nodebug\n");
     exit();
    }
  }
  for (i=1, j=2; j <= heapcount; i++, j++)
  {
    vi = vdata[vheap[i].v].redsurplus;
    vj = vdata[vheap[j].v].redsurplus;
    if (vj < vi) goto error;
    if (j == heapcount) break;
    j++;
    vj = vdata[vheap[j].v].redsurplus;
    if (vj < vi) goto error;
    continue;
  error:;
    click_message("heap value error: %d %d %d %d\n",i,j,vi,vj);
    printf("nodebug\n");
    exit();
  }
}

