/* @copyright 1996, The Regents of the University of California
   bipartite matching using Hopcroft-Karp algorithm.   The algorithm
   first colors the graph, then does the matching */

#include <stdio.h>
#include <math.h>
#include "graphtool.h"

#define NUM_NODES 300
#define NUM_EDGES 300

#define BOOL int
#define FALSE 0
#define TRUE 1

#define DEBUGGING 0

extern int num_edges,num_nodes,directed;
struct node *nodes=NULL;
struct edge *edges=NULL;

struct node *red[NUM_NODES], *blue[NUM_NODES];

#define BLUE 1
#define RED 2
#define OPPCOLOR(i) (3-(i))
int nodecolor[NUM_NODES];
int redcount=0, bluecount=0;
struct edge *match_edge[NUM_NODES];
int matchcount = 0, phasecount = 0;

void quickexit();
void colornodes();
void colornode ARGS((int,int));
void dophase ARGS((BOOL *));
void build_bfs_tree ARGS((BOOL *));
void augment_matching();
void update_edge_display ARGS((int,int,int));
void update_node_display ARGS((int,int));

main()
{
  BOOL stuck;
  int i;
  double length;
  ar_read_graph(stdin,&nodes,&edges,NUM_NODES,1,NUM_EDGES,1);
  line_buffer(stdout);
  printf("#debug bipmatch.dbg\n"); /*debug*/
  vertex_edge_lists(edges+1);
  
  colornodes();
#if DEBUGGING
  for (i=1; i <= num_nodes; i++) 
    if (nodecolor[i] == RED) 
      update_node_display(i,-1);
  click_message("nodes colored\n");
#endif
  for (stuck = FALSE; !stuck && (bluecount > matchcount); dophase(&stuck));

  /* output matching */
  for (i=1, length = 0.0; i <= num_nodes; i++)
  {
    if ((nodecolor[i] == BLUE) && (match_edge[i] != NULL))
    {
      update_edge_display(match_edge[i]->num,5,-1);
    }
  }
  click_message("optimum matching found: %d edges, %d phases\n",matchcount,
                phasecount);

  printf("#nodebug\n");
  flush_pipe();
}

void quickexit()
{
  printf("#nodebug\n");
  flush_pipe();
  exit(99);
}

void colornodes()
{
  struct node *node;
  struct edge *edge, *startedge;
  int i,v;
  int nodestack[num_nodes];
  int depth = 0, w,x;
  
  for (v = 1; v <= num_nodes; v++) nodecolor[v] = 0;
  
  for (v = 1; v <= num_nodes; v++) 
    if (nodecolor[v] == 0)
      colornode(v,BLUE);
}

void colornode(v,color)
int v,color;
{
  struct edge *edge, *startedge;
  struct node * node;
  int w;
  if (nodecolor[v] == color) return;
  if (nodecolor[v] == OPPCOLOR(color))
  {
    click_message("error: graph is not bipartite\n");
    quickexit();
  }
  if (nodecolor[v] != 0)
  {
    click_message("error: weird color: %d\n",nodecolor[v]);
    quickexit();
  }
  nodecolor[v] = color;
  node = &nodes[v];
  if (color ==RED) red[++redcount] = node;
  else blue[++bluecount] = node;
  for (startedge = edge = node->vh; edge != NULL; )
  {
    w = OPP_VERTPI(edge,node);
    colornode(w,OPPCOLOR(color));
    edge = SUCCPP(edge,node);
    if (edge == startedge) edge = NULL;
  }
}

struct bfsnode {
  struct node *p_node;
  struct bfsnode * next; /* next bfsnode at current level */
  struct bfsedge *edgehead;
  int level;
  BOOL onpath;
} bfs_node[NUM_NODES];
int bfs_ncount;

struct bfsnode sourcenode, sinknode;
struct bfsnode *source = &sourcenode, *sink = &sinknode;

struct bfsedge {
  struct bfsnode *child;
  struct bfsedge *next;
  struct edge *edge;
} bfs_edge[NUM_EDGES];
int bfs_ecount;

void dophase(stuck)
int *stuck;
{
  phasecount++;
  build_bfs_tree(stuck);
  if (!(*stuck)) augment_matching(); 
}

void build_bfs_tree(stuck)
int *stuck;
{
  struct bfsnode *treeloc[NUM_NODES];
  int v,curlevel = 1;
  struct bfsnode *bluelevelhead = NULL, *redlevelhead = NULL;
  struct bfsnode **prevbfsnode,*b,*bparent;
  struct bfsedge **prevbfsedge,*be;
  struct node *node, *childnode;
  struct edge *edge;
  BOOL freeredfound;

#if DEBUGGING
  click_message("entering build_bfs_tree\n");
#endif
  bfs_ncount = bfs_ecount = 0;
  sourcenode.p_node = sinknode.p_node = NULL;
  sourcenode.next = sinknode.next = NULL;
  sourcenode.edgehead = sinknode.edgehead = NULL;
  for (prevbfsnode = &bluelevelhead, prevbfsedge = &sourcenode.edgehead,v=1; 
       v <= num_nodes; v++)
  {
    if ((nodecolor[v] == BLUE) && (match_edge[v] == NULL))
    {
      b = &bfs_node[++bfs_ncount];
      b->p_node = &nodes[v];
      b->next = NULL;
      b->edgehead = NULL;
      *prevbfsnode = b;
      prevbfsnode = &b->next;
      b->level = curlevel;
      treeloc[v] = b;
      be = &bfs_edge[++bfs_ecount];
      be->child = b;
      be->next = NULL;
      be->edge = NULL;
      *prevbfsedge = be;
      prevbfsedge = &be->next; 
    #if DEBUGGING
      update_node_display(v,3);
      click_message("node %d blue, unmatched\n",v);
      update_node_display(v,-2);
    #endif
    }
    else treeloc[v] = NULL;
  } 
#if DEBUGGING
  click_message("unmatched blue nodes found\n");
#endif
  for (freeredfound = FALSE; !freeredfound; )
  {
    curlevel++;
    prevbfsnode = &redlevelhead;
    redlevelhead = NULL;
    for (bparent = bluelevelhead; bparent != NULL; bparent=bparent->next)
    {
      node = bparent->p_node;
      prevbfsedge = &bparent->edgehead;
      for (edge = node->vh; edge != NULL; edge = SUCCPP(edge,node))
      {
        childnode = OPP_VERTPP(edge,node);
        if (treeloc[childnode->num] == NULL)
        {
          b = &bfs_node[++bfs_ncount];
          b->p_node = childnode;
          b->next = NULL;
          b->edgehead = NULL;
          *prevbfsnode = b;   
          prevbfsnode = &b->next;   
          b->level = curlevel; 
          treeloc[childnode->num] = b;   
          if (match_edge[childnode->num]  == NULL) freeredfound = TRUE;
        }  
        else if ((treeloc[childnode->num])->level == curlevel)
          b = treeloc[childnode->num];
        else b = NULL;
        if (b != NULL)
        {
          be = &bfs_edge[++bfs_ecount];
          be->child = b;
          be->next = NULL;
          be->edge = edge;
          *prevbfsedge = be;
          prevbfsedge = &be->next;
        #if DEBUGGING
          update_edge_display(edge->num,3,-1);
          click_message("adding edge %d to tree\n",edge->num);
        #endif
        }
      }
    }
  #if DEBUGGING
    click_message("blue-red step complete, curlevel = %d\n",curlevel);
  #endif
    if (!freeredfound)
    {
      curlevel++;
      bluelevelhead = NULL;
      prevbfsnode = &bluelevelhead;
      for (bparent = redlevelhead; bparent != NULL; bparent = bparent->next)
      {
        edge = match_edge[bparent->p_node->num];
        childnode = OPP_VERTPP(edge,bparent->p_node);
        b = &bfs_node[++bfs_ncount];
        b->p_node = childnode; 
        b->next = NULL;
        b->edgehead = NULL;
        *prevbfsnode = b;   
        prevbfsnode = &b->next;   
        b->level = curlevel; 
        treeloc[childnode->num] = b;   
        be = &bfs_edge[++bfs_ecount];
        be->child = b;
        be->next = NULL;
        be->edge = edge;
        bparent->edgehead = be;
      }
  #if DEBUGGING
      click_message("red-blue step complete, curlevel = %d\n",curlevel);
  #endif
    }
  }
  for (bparent = redlevelhead; bparent != NULL; bparent = bparent->next)
    if (match_edge[bparent->p_node->num] == 0)
    {
      be = &bfs_edge[++bfs_ecount];
      be->child = sink;
      be->next = NULL;
      be->edge = NULL;
      bparent->edgehead = be;
    }
#if DEBUGGING
  click_message("leaving build_bfs_tree\n");
#endif
}

void augment_matching()
{
  struct stackent {
    struct bfsnode *bfs_node;
    struct bfsedge *bfs_edge;
  } bfs_stack[NUM_NODES], *top;
  int depth = 0,i,d; 
  struct bfsnode *f;
  struct bfsedge *fe;
  struct node *bluenode, *rednode, *nextbluenode;
  struct edge *oldmatchededge;

#if DEBUGGING
  click_message("entering augment_matching\n");
#endif
  for (i=1; i <= bfs_ncount; i++) bfs_node[i].onpath = FALSE;
  sourcenode.onpath = TRUE; sinknode.onpath = FALSE;
  top = &bfs_stack[++depth];
  top ->bfs_node = source;
  top->bfs_edge = NULL;
  while (depth > 0)
  {
    while ((fe = bfs_stack[depth].bfs_node->edgehead) != NULL)
    {
      top = &bfs_stack[depth];
      f = fe->child;
      top->bfs_node->edgehead = fe->next;
      if (!f->onpath)
      {
      #if DEBUGGING
        if (f->p_node != NULL)
        {
          update_node_display(f->p_node->num,3);
          click_message("visiting node %d\n",f->p_node->num);
        }
      #endif
        top = &bfs_stack[++depth];
        top->bfs_node = f;
        top->bfs_edge = fe;
        if (top->bfs_node != sink) f->onpath = TRUE;
        else
        {
          /* augmenting path found: augment matching */
        #if DEBUGGING
          click_message("extracting augmenting path, depth = %d\n",depth);
        #endif
          for (d = 2; d < depth - 1; d = d + 2)
          {
            bluenode =  bfs_stack[d].bfs_node->p_node;
            if (nodecolor[bluenode->num] != BLUE)
            {
              click_message("blue node expected %d %d %d\n",bluenode->num,
                            nodecolor[bluenode->num],d);
              quickexit();
            }
            rednode =  bfs_stack[d+1].bfs_node->p_node;
            if (nodecolor[rednode->num] != RED)
            {
              click_message("red node expected %d %d %d\n",rednode->num,
                            nodecolor[rednode->num],d+1);
              quickexit();
            }
            oldmatchededge = match_edge[rednode->num];
            if ((d == depth - 2 && oldmatchededge != NULL) ||
                (d < depth - 2 && oldmatchededge == NULL))
            {
              click_message("depth/match discrepancy: %d %d %o\n",
                            d,depth,oldmatchededge);
              quickexit();
            }
            if (oldmatchededge != NULL)
            {
              match_edge[rednode->num] = NULL;
              nextbluenode = bfs_stack[d+2].bfs_node->p_node;
              match_edge[nextbluenode->num] = NULL;
              matchcount--;
          #if DEBUGGING
            update_edge_display(oldmatchededge->num,1,-1);
            click_message("removing edge %d : (%d,%d)\n",
                           oldmatchededge->num, rednode->num,nextbluenode->num);
          #endif
            }
            match_edge[rednode->num] = match_edge[bluenode->num] =
              bfs_stack[d+1].bfs_edge->edge;
          #if DEBUGGING
            update_edge_display(bfs_stack[d+1].bfs_edge->edge->num,5,-1);
            click_message("augmenting edge %d : (%d,%d)\n",
                           bfs_stack[d+1].bfs_edge->edge->num,
                           rednode->num,bluenode->num);
          #endif
            matchcount++;
          }
        #if DEBUGGING
          click_message("matching augmented, matchcount = %d\n",matchcount);
        #endif
          depth = 1;
        }
      }
    }
    depth--;
  }
#if DEBUGGING
  click_message("leaving augment_matching\n");
  for (i=1; i <= num_edges; i++)
    if (edges[i].width != 5) update_edge_display(i,1,edges[i].style);
  for (i=1; i <= num_nodes; i++)
    update_node_display(i, ((nodecolor[i] == RED)?(-1):(-2)));
#endif
}

void update_edge_display(e,width,style)
int e, width, style;
{
  struct edge *edge;
  edge = &edges[e];
  edge->width = width;
  edge->style = style;
  printf("#edgep %d %d %d\n",e,width,style);
}

void update_node_display(n,pattern)
int n, pattern;
{
  struct node *node;
  node = &nodes[n];
  node->pattern = pattern;
  printf("#nodep %d %d\n",n,pattern);
}
