/* @copyright 1996, The Regents of the University of California
 * Compute convex hull, using Jarvis March */

#include <stdio.h>
#include "graphtool.h"

double pseudoangle();

#define NUM_NODES 300
#define NUM_EDGES 600
extern int num_edges,num_nodes;
struct node *nodes=NULL;
struct edge *edges=NULL;

main()
{
  int i,k,bestpt,minx;
  double x1,x2,y1,y2,bestval,newval;
  int edgecount = 0;
  
  ar_read_graph(stdin,&nodes,&edges,NUM_NODES,0,NUM_EDGES,0);
  line_buffer(stdout);

  if (num_edges != 0)
  {
    click_message("No edges allowed\n");
    goto exit99;
  }

  for (minx = 0,i=1; i < num_nodes; i++)
     if (nodes[i].x < nodes[minx].x) minx = i;
  for (k=minx,x1=nodes[minx].x,y1=nodes[minx].y-1;;)
  {
    x2 = nodes[k].x;
    y2 = nodes[k].y;
    bestpt = (k==0)?1:0;
    bestval = pseudoangle(x1,y1,x2,y2,nodes[bestpt].x,nodes[bestpt].y);
    i = bestpt + 1;
    for (; i < num_nodes; i++)
    {
      if (i == k) goto cont;
      newval = pseudoangle(x1,y1,x2,y2,nodes[i].x,nodes[i].y);
      if (newval > bestval)
      {
        bestval = newval;
        bestpt = i;
      }
  cont:;
    }
    printf("#edge+ %d %d %d 1 1 -1\n", ++edgecount,k+1,bestpt+1);
    k = bestpt;
    x1 = x2;
    y1 = y2;
    if (k==minx) goto exit99;
  }
exit99:;
  flush_pipe();
}

double pseudoangle(x1,y1,x2,y2,x3,y3)
double x1,y1,x2,y2,x3,y3;
{
  double r,r1,r2,r3,sgn;
  r1 = (x3-x2)*(x2-x1) + (y3-y2)*(y2-y1);
  sgn = (r1>0)?1:-1;
  r2 = (x3-x2)*(x3-x2) + (y3-y2)*(y3-y2);
  r3 = (x2-x1)*(x2-x1) + (y2-y1)*(y2-y1);
  r = sgn*r1*r1/(r2*r3);
  return(r);
}
