/* @copyright 1996, The Regents of the University of California
 * Compute convex layers, by successive applications of Jarvis March */

#include <stdio.h>
#include <math.h>
#include "graphtool.h"

#define NUM_NODES 300
#define NUM_EDGES 300
struct node *nodes=NULL;
struct edge *edges=NULL;
extern int num_nodes,num_edges;

int hull();
double pseudoangle();

struct vertex_entry
{
   int v;
   struct vertex_entry *vnext,*vprev;
} varray[NUM_NODES], *vhead, *vtail;

int edgecount = 0;

main()
{
  int nodecount,i,layercount=0;
  struct vertex_entry **vpp,*prev;

  ar_read_graph(stdin,&nodes,&edges,NUM_NODES,1,NUM_EDGES,1);
  line_buffer(stdout);

  if (num_edges != 0)
  {
    click_message("No edges allowed!\n");
    goto exit99;
  }
  vpp = &vhead;
  prev = 0;
  for (i=1; i <= num_nodes; i++)
  {
    varray[i].v = i;
    varray[i].vnext = 0;
    varray[i].vprev = prev;
    prev = *vpp = &varray[i];
    vpp = &varray[i].vnext;
  }
  vtail = prev;
  for (nodecount = num_nodes; nodecount >= 2;) 
  {
    nodecount = hull(nodecount);
    layercount++;
  }
  if (nodecount > 0) layercount++;
  click_message("%d layers\n",layercount);
exit99:;
  flush_pipe();
}

double pseudoangle(x1,y1,x2,y2,x3,y3)
double x1,y1,x2,y2,x3,y3;
{
  double r,r1,r2,r3,sgn;
  r1 = (x3-x2)*(x2-x1) + (y3-y2)*(y2-y1);
  sgn = (r1>0)?1:-1;
  r2 = (x3-x2)*(x3-x2) + (y3-y2)*(y3-y2);
  r3 = (x2-x1)*(x2-x1) + (y2-y1)*(y2-y1);
  r = sgn*r1*r1/(r2*r3);
  return(r);
}

int hull(nodecount)
int nodecount;
{
  int k, minx;
  double x1,x2,y1,y2,bestval,newval;
  struct vertex_entry *bestvp, *vp;
  char str[80];

  for (vp = vhead->vnext, minx = vhead->v; vp != 0; vp = vp->vnext)
     if (nodes[vp->v].x < nodes[minx].x) minx = vp->v;
  for (k=minx,x1=nodes[minx].x,y1=nodes[minx].y-1;;)
  {
    x2 = nodes[k].x;
    y2 = nodes[k].y;
    bestvp = (k==vhead->v)?vhead->vnext:vhead;
    bestval = pseudoangle(x1,y1,x2,y2,nodes[bestvp->v].x,nodes[bestvp->v].y);
    vp = bestvp->vnext;
    for (; vp != 0; vp = vp->vnext)
    {
      if (vp->v == k) goto cont;
      newval = pseudoangle(x1,y1,x2,y2,nodes[vp->v].x,nodes[vp->v].y);
      if (newval > bestval)
      {
        bestvp = vp;
        bestval = newval;
      }
  cont:;
    }
    printf("#edge+ %d %d %d 1 1 -1\n", ++edgecount,k,bestvp->v);
    if (bestvp->vnext == 0) vtail = bestvp->vprev;
    else bestvp->vnext->vprev = bestvp->vprev;
    if (bestvp->vprev == 0) vhead = bestvp->vnext;
    else bestvp->vprev->vnext = bestvp->vnext;
    nodecount = nodecount - 1;
    k = bestvp->v;
    x1 = x2;
    y1 = y2;
    if (k==minx) 
    {
      return(nodecount);
    }
  }
}
