/* @copyright 1996, The Regents of the University of California
   Compute Delaunay triangulation, using simple O(N**2) algorithm due to
   (I think) McLain */

#include <stdio.h>
#include <math.h>
#include "graphtool.h"

#define NUM_NODES 2000
#define NUM_EDGES 6000

double pseudoangle();
int edgestack[NUM_EDGES];
int depth = 0;
#define SMALLVAL -1.0e10

struct node *nodes=NULL;
struct edge *edges=NULL;
extern int num_nodes,num_edges;

main()
{
  int i, hullcount;
  
  ar_read_graph(stdin,&nodes,&edges,NUM_NODES,1,NUM_EDGES,1);
  line_buffer(stdout);
  for (i=1;i<=num_nodes;i++) nodes[i].vh=NULL;

  if (num_edges != 0)
  {
    click_message("No edges allowed\n");
    goto exit99;
  }
  hull();
  hullcount = num_edges;
  tri();
  click_message("hullcount = %d, tricount = %d, expected = %d\n",
    hullcount, num_edges, 3 * num_nodes - 3 - hullcount);

exit99:;
  flush_pipe();
}

hull()
{
  int i,k,bestpt,minx,e;
  char str[80];
  double x1,x2,y1,y2,bestval,newval;
  
  for (minx = 1,i=2; i <= num_nodes; i++)
     if (nodes[i].x < nodes[minx].x) minx = i;
  for (k=minx,x1=nodes[minx].x,y1=nodes[minx].y-1;;)
  {
    x2 = nodes[k].x;
    y2 = nodes[k].y;
    bestpt = (k==1)?2:1;
    bestval = pseudoangle(x1,y1,x2,y2,nodes[bestpt].x,nodes[bestpt].y);
    i = bestpt + 1;
    for (; i <= num_nodes; i++)
    {
      if (i == k) goto cont;
      newval = pseudoangle(x1,y1,x2,y2,nodes[i].x,nodes[i].y);
      if (newval > bestval)
      {
        bestval = newval;
        bestpt = i;
      }
  cont:;
    }
    e = addedge(k,bestpt);
    pushedge(e);
    /* printf("#edge+ %d %d %d 1 1 -1\n", e,k,bestpt); */
    k = bestpt;
    x1 = x2;
    y1 = y2;
    if (k==minx) return;
  }
}

tri()
{
  int poppededge,e,f,t,besti,i;
  double x1,x2,x3,y1,y2,y3,bestval,nx,ny,newval;
  while (depth>0)
  {
    poppededge = popedge();
    f = edges[poppededge].i_from;
    t = edges[poppededge].i_to;
    /* printf("#edgep %d 5 3\n",poppededge);
       printf("#nodep %d -1\n",f); 
       printf("#nodep %d 3\n",t); */
    x1 = nodes[f].x; y1 = nodes[f].y;
    x3 = nodes[t].x; y3 = nodes[t].y;
    nx = y3 - y1;
    ny = x1 - x3;
    bestval = SMALLVAL;
    besti = 0;
    for (i=1; i <= num_nodes; i++)
    {
       if ((i==f) || (i==t)) continue;
       x2 = nodes[i].x;
       y2 = nodes[i].y;
       if ((x2-x1)*nx + (y2-y1)*ny <= 0) continue;
       newval = pseudoangle(x1,y1,x2,y2,x3,y3);
       if (newval > bestval)
       {
         bestval = newval;
         besti = i;
       }
    }
    if (besti == 0) goto cont;
    /* checkcirc(f,t,besti,poppededge); */
    if (findedge(f,besti) == 0)
    {
       e = addedge(f,besti);
       pushedge(e);
    }
    if (findedge(besti,t) == 0)
    {
       e = addedge(besti,t);
       pushedge(e);
    }
  cont:;
    /* printf("#nodep %d -2\n",f); 
       printf("#nodep %d -2\n",t); 
       printf("#edgep %d 1 -1\n",poppededge); */
  }
}

checkcirc(v1,v2,v3,e)
int v1,v2,v3,e;
{
  double x1,y1,x2,y2,x3,y3,mpx1,mpx2,mpy1,mpy2,s1,s2,centx,centy,dx,dy,x,y,r,r2;
  int i;
  x1 = nodes[v1].x; y1 = nodes[v1].y;
  x2 = nodes[v2].x; y2 = nodes[v2].y;
  x3 = nodes[v3].x; y3 = nodes[v3].y;
  mpx1=(x1+x2)/2;
  mpy1=(y1+y2)/2;
  mpx2=(x2+x3)/2;
  mpy2=(y2+y3)/2;
  s1= -(x1-x2)/(y1-y2);
  s2= -(x3-x2)/(y3-y2);
  centx=(s1*mpx1-s2*mpx2+mpy2-mpy1)/(s1-s2);
  centy=s1*centx-s1*mpx1+mpy1;
  dx=x1-centx;
  dy=y1-centy;
  r2=dx*dx+dy*dy;
  r = sqrt(r2);
  printf("#circle %lf %lf %lf 0\n",centx,centy,r);
  printf("#redraw\n");
  for (i=1; i <= num_nodes; i++)
  {
    if ((i==v1) || (i == v2) || (i == v3)) continue;
    x = nodes[i].x; y = nodes[i].y;
    if ((x-centx) * (x-centx) + (y-centy) * (y-centy) < r2)
    {
      click_message("Anomaly: %d %d %d %d \n",v1,v2,v3,i);
      printf("#nodep %d -1\n",v1); 
      printf("#nodep %d -1\n",v2); 
      printf("#nodep %d -1\n",v3); 
      printf("#nodep %d 4\n",i); 
      r = sqrt(r2);
      printf("#circle %lf %lf %lf 0\n",centx,centy,r);
      printf("#edgep %d 5 3\n",e);
      click_message("Anomaly: %d %d %d %d \n",v1,v2,v3,i);
      return;
    } 
  } 
}


int addedge(f,t)
int f,t;
{
  struct edge *edge;
  struct node *node;
  int e;
  if (num_edges >= NUM_EDGES - 1)
  {
    click_message("**Edge overflow!\n");
    exit(99);
  }
  edge = &edges[e=++num_edges];
  edge->i_from = f;
  edge->i_to = t;
  edge->p_from = &nodes[f];
  edge->p_to = &nodes[t];
  edge->num = num_edges;
  edge->weight = 1;
  edge->width = 1;
  edge->style = -1;
  printf("#edge+ %d %d %d 1 1 -1\n",e,f,t);
  vertex_edge(&nodes[f],&nodes[t],edge);
  return(e);
}

int findedge(f,t)
int f,t;
{
  int v;
  int r = 0;
  struct edge *e;
  
 /* printf("#nodep %d -1\n",f);     */
 /* printf("#nodep %d 0\n",t);     */
   /* click_message("findedge: f,t = %d %d\n",f,t);    */

  e = nodes[f].vh;
  while (e != NULL)
  {
    v = OPP_VERTII(e,f);
  
/* printf("#edgep %d 3 -1\n",e);   */
/* printf("#nodep %d 5\n",v);    */
  /* click_message("f,t,v,e = %d %d %d %d\n",f,t,v,e);   */
/* printf("#edgep %d 1 -1\n",e);   */
/* printf("#nodep %d -2\n",v);    */
    if (v == t)
    {
       r = e->num;
       break;
    } 
    e = SUCCIP(e,f);
  }
       
   /* click_message("findedge returning %d\n",r);    */
 /* printf("#nodep %d -2\n",f);     */
 /* printf("#nodep %d -2\n",t);     */
  return(r);
}

double pseudoangle(x1,y1,x2,y2,x3,y3)
double x1,y1,x2,y2,x3,y3;
{
  double r,r1,r2,r3,sgn;
  r1 = (x3-x2)*(x2-x1) + (y3-y2)*(y2-y1);
  sgn = (r1>0)?1:-1;
  r2 = (x3-x2)*(x3-x2) + (y3-y2)*(y3-y2);
  r3 = (x2-x1)*(x2-x1) + (y2-y1)*(y2-y1);
  r = sgn*r1*r1/(r2*r3);
  return(r);
}

pushedge(e)
int e;
{
  edgestack[depth++] = e;
}

int popedge()
{
  return(edgestack[--depth]);
}
