/* @copyright 1996, The Regents of the University of California
 * Compute total edge length */

#include <stdio.h>
#include <math.h>
#include "graphtool.h"

#define NUM_NODES 900
#define NUM_EDGES 900

extern int num_edges,num_nodes,directed;
struct node *nodes=NULL;
struct edge *edges=NULL;

main()
{
  int i, source, target, e, starte, v, w;
  struct edge *edge;
  struct node *np1, *np2;
  double length = 0.0;

  ar_read_graph(stdin,&nodes,&edges,NUM_NODES,1,NUM_EDGES,1);
  line_buffer(stdout);

  for (i=1; i <= num_edges; i++)
  {
    np1 = edges[i].p_from;
    np2 = edges[i].p_to;
    length = length + hypot(np1->x - np2->x, np1->y - np2->y);
  }
  click_message("total edge length = %lf\n",length);
  flush_pipe();
}
