/* @copyright 1996, The Regents of the University of California
 * Compute longest and shortest edges */

#include <stdio.h>
#include <math.h>
#include "graphtool.h"

#define MAG2(x,y) (((x)*(x)) + ((y)*(y)))

struct node *nodes=NULL;
struct edge *edges=NULL;

extern int num_edges;

main()
{
  int shortedge=1, longedge = 1, i,t,f;
  double shortlen, longlen, len;
  
  ar_read_graph(stdin,&nodes,&edges,300,1,300,1);
  line_buffer(stdout);

  if (num_edges == 0)
  {
    click_message("No edges allowed\n");
    goto exit99;
  }
  f = edges[1].i_from;
  t = edges[1].i_to;
  shortlen = longlen = MAG2((nodes[t].x-nodes[f].x),(nodes[t].y-nodes[f].y));
  for (i=2; i <= num_edges;i++)
  {
    f = edges[i].i_from;
    t = edges[i].i_to;
    len = MAG2((nodes[t].x-nodes[f].x),(nodes[t].y-nodes[f].y));
    if (len > longlen)
    {
      longedge = i;
      longlen = len;
    }
    if (len < shortlen)
    {
      shortedge = i;
      shortlen = len;
    }
  }
  printf("#edgep %d 5 -1\n",shortedge);
  printf("#edgep %d 5 -1\n",longedge);
exit99:;
  flush_pipe();
}
