/* @copyright 1996, The Regents of the University of California
 * Display each face and the sum of the weights of the vertices
 * incident on the face.  Useful for checking the validity
 * of Rivin-Smith (inscribability) weightings.
*/

#include <stdio.h>
#include <math.h>
#include "graphtool.h"

#define BOOL int
#define FALSE 0
#define TRUE 1

#define NUM_NODES 300
#define NUM_EDGES 300

char str[200];

extern int num_edges,num_nodes,directed;
struct node *nodes=NULL;
struct edge *edges=NULL;


main()
{
  int i, j, e, e1, v1, s, nfaces, edgesinface;
  double faceweightsum;
  int edge_list[NUM_EDGES];
  BOOL edge_marks[NUM_EDGES][2];
  struct edge *edge;
  
  ar_read_graph(stdin,&nodes,&edges,NUM_NODES,1,NUM_EDGES,1);
  line_buffer(stdout);

  vertex_edge_lists(edges+1);
  sort_vertex_edge_lists(nodes+1); 

/* process faces */
  for (e=1; e <= num_edges; e++)
    edge_marks[e][0] = edge_marks[e][1] = FALSE;
  nfaces = 0;
  for (e=1; e <= num_edges; e++)
  {
    for (j=0; j <= 1; j++)
    {
      if (!edge_marks[e][j])
      {
        nfaces++;
        edgesinface = 0;
        faceweightsum = 0;
        edge_marks[e][j] = TRUE;
        e1 = e;
        edge = &edges[e1];
        v1 = (j==0)? edges[e1].i_from : edges[e].i_to;
        v1 = OPP_VERTII(edge,v1);
        edge_list[edgesinface++] = e1;
        printf("#edgep %d 5 -1\n",e1);
        faceweightsum = edge->weight;
        e1 = CCWII(edge,v1);
        while (e1 != e)
        {
          edge = &edges[e1];
          s = (edge->i_from == v1)? 0 : 1;
          edge_marks[e1][s] = TRUE;
          v1 = OPP_VERTII(edge,v1); 
          edge_list[edgesinface++] = e1;    
          printf("#edgep %d 5 -1\n",e1);
          faceweightsum = faceweightsum + edge->weight;
          e1 = CCWII(edge,v1);
        }
        click_message("face sum = %lf\n",faceweightsum);
        for (i=0; i < edgesinface; i++) printf("#edgep %d 1 -1\n",edge_list[i]);
      }
    }
  }
  click_message("face count = %d\n",nfaces);
  flush_pipe();
}

