/* @copyright 1996, The Regents of the University of California 
   flipdt: compute Delaunay triangulation by edge flipping.  Use
   greedy (queuing) strategy, for now */

#include <stdio.h>
#include <math.h>
#include "graphtool.h"

#define NUM_NODES 6000
#define NUM_EDGES 2000

#define BOOL int
#define FALSE 0
#define TRUE 1

extern int num_edges,num_nodes,directed;
struct node *nodes=NULL;
struct edge *edges=NULL;

int qhead = 0, qtail = 0;
int flipcount = 0;

#define HULL 1
#define ONQUEUE 2
#define ELIGIBLE 0

int edgestatus[NUM_EDGES + 2];
int queue [NUM_EDGES + 2];
#define QUEUETOP (NUM_EDGES+1)

main()
{

  int i,e;
  char str[80];

  ar_read_graph(stdin,&nodes,&edges,NUM_NODES,1,NUM_EDGES,1);
  line_buffer(stdout);
  vertex_edge_lists(edges+1);
  sort_vertex_edge_lists(nodes+1); 

  for (i=1; i <= num_edges; i++)
  {
    test_and_queue(i);
  }
  while(qhead != qtail)
  {
    e = pop_queue();
    test_and_process(e);
  }
  click_message("%d flips\n",flipcount);
  printf("#nodebug\n");
  flush_pipe();
}

quickexit()
{
  printf("#nodebug\n");
  flush_pipe();
  exit(99);
}

int test_and_queue(e)
int e;
{
  struct edge *edge,*edge13,*edge14,*edge23,*edge24;
  struct node *node1, *node2, *node3, *node4;
  BOOL offhull;

  edge = &edges[e];
  node1 = edge->p_from;
  node2 = edge->p_to;
  edge13 = CCWPP(edge,node1);
  edge14 = CWPP(edge,node1);
  edge23 = CWPP(edge,node2);
  edge24 = CCWPP(edge,node2);
  node3 = OPP_VERTPP(edge13,node1);
  offhull = (node3 == OPP_VERTPP(edge23,node2));
  node4 = OPP_VERTPP(edge14,node1);
  offhull = offhull && (node4 == OPP_VERTPP(edge24,node2));
  if (!offhull)
  {
    edgestatus[e] = HULL;
    return;
  }
  if (incircle(node1->x,node1->y,node2->x,node2->y,
               node3->x,node3->y,node4->x,node4->y))
    push_queue(e);
  else edgestatus[e] = ELIGIBLE;
}


test_and_process(e)
int e;
{
  struct node *node1, *node2, *node3, *node4;
  struct edge *edge,*edge13,*edge14,*edge23,*edge24;

  if (edgestatus[e] != ONQUEUE)
  {
    click_message("status descrepancy: %d %d %d\n",e,ONQUEUE,edgestatus[e]);
    quickexit();
  }
  edgestatus[e] = ELIGIBLE;
  edge = &edges[e];
  node1 = edge->p_from;
  node2 = edge->p_to;
  edge13 = CCWPP(edge,node1);
  edge14 = CWPP(edge,node1);
  edge23 = CWPP(edge,node2);
  edge24 = CCWPP(edge,node2);
  node3 = OPP_VERTPP(edge13,node1);
  node4 = OPP_VERTPP(edge14,node1);
  /* check if flip necessary */
  if (!incircle(node1->x,node1->y,node2->x,node2->y,
               node3->x,node3->y,node4->x,node4->y))
    return;
  /* flip diagonal */
  flipcount++;
  if (node1->vh == edge) node1->vh = edge13;
  if (node1->vt == edge) node1->vt = edge13;
  if (node2->vh == edge) node2->vh = edge23;
  if (node2->vt == edge) node2->vt = edge23;
  if (edge13->p_from == node1) edge13->from_prev = edge14;
  else edge13->to_prev = edge14;
  if (edge14->p_from == node1) edge14->from_next = edge13;
  else edge14->to_next = edge13;
  if (edge23->p_from == node2) edge23->from_next = edge24;
  else edge23->to_next = edge24;
  if (edge24->p_from == node2) edge24->from_prev = edge23;
  else edge24->to_prev = edge23;
  printf("#edge- %d\n",edge->num);
  edge->from_next = edge23;
  edge->from_prev = edge13;
  edge->to_next = edge14;
  edge->to_prev = edge24;
  edge->i_from = node3->num;
  edge->i_to = node4->num;
  edge->p_from = node3;
  edge->p_to = node4;
  if (edge13->p_from == node3) edge13->from_next = edge;
  else edge13->to_next = edge;
  if (edge23->p_from == node3) edge23->from_prev = edge;
  else edge23->to_prev = edge;
  if (edge14->p_from == node4) edge14->from_prev = edge;
  else edge14->to_prev = edge;
  if (edge24->p_from == node4) edge24->from_next = edge;
  else edge24->to_next = edge;
  printf("#edge+ %d %d %d %lf %d %d\n",edge->num,node3->num,
         node4->num,edge->weight,edge->width,edge->style);
  /* now check to see if any new edges must be queued */
  check_for_queueing(edge13,node1,node4);
  check_for_queueing(edge23,node3,node4);
  check_for_queueing(edge14,node4,node3);
  check_for_queueing(edge24,node2,node3);
    
}

check_for_queueing(edge,refnode,oppnode)
struct edge *edge;
struct node *refnode, *oppnode;
{
  struct edge *nextedge;
  struct node *testnode, *othernode;
  if (edgestatus[edge->num] != ELIGIBLE) return;
  nextedge = CCWPP(edge,refnode);
  testnode = OPP_VERTPP(nextedge,refnode);
  othernode = OPP_VERTPP(edge,refnode);
  if (incircle(refnode->x,refnode->y,othernode->x,othernode->y,
               oppnode->x,oppnode->y,testnode->x,testnode->y))
    push_queue(edge->num);
}


circumcircle(x1,y1,x2,y2,x3,y3)
double x1,x2,x3,y1,y2,y3;
{
   double x,y,mpx1,mpx2,mpy1,mpy2,s1,s2,r,sqrt(),dx,dy;

   mpx1=(x1+x2)/2;
   mpy1=(y1+y2)/2;
   mpx2=(x2+x3)/2;
   mpy2=(y2+y3)/2;
   s1= -(x1-x2)/(y1-y2);
   s2= -(x3-x2)/(y3-y2);
   x=(s1*mpx1-s2*mpx2+mpy2-mpy1)/(s1-s2);
   y=s1*x-s1*mpx1+mpy1;
   dx=x1-x;
   dy=y1-y;
   r=sqrt(dx*dx+dy*dy);
   printf("#circle %lf %lf %lf 0\n",x,y,r);
}

#define MINVAL 1.0e-10 

BOOL incircle(x1,y1,x2,y2,x3,y3,x4,y4)
double x1,x2,x3,y1,y2,y3,x4,y4;
/* is (x4,y4) in circle through (x1,y1), (x2,y2), (x3,y3)? */
{
   double x,y,mpx1,mpx2,mpy1,mpy2,s1,s2,r2,dx,dy,dx4,dy4,d4;
   double temp;
   BOOL retval;

   if (fabs(y1-y2) < MINVAL)
   {
      temp = x2; x2 = x3; x3 = temp;
      temp = y2; y2 = y3; y3 = temp;
   }
   else if (fabs(y3-y2) < MINVAL)
   {
      temp = x2; x2 = x1; x1 = temp;
      temp = y2; y2 = y1; y1 = temp;
   }
   mpx1=(x1+x2)/2;
   mpy1=(y1+y2)/2;
   mpx2=(x2+x3)/2;
   mpy2=(y2+y3)/2;
   s1= -(x1-x2)/(y1-y2);
   s2= -(x3-x2)/(y3-y2);
   x=(s1*mpx1-s2*mpx2+mpy2-mpy1)/(s1-s2);
   y=s1*x-s1*mpx1+mpy1;
   dx=x1-x;
   dy=y1-y;
   r2=dx*dx+dy*dy;
   dx4 = (x4-x);
   dy4 = (y4-y);
   d4 = dx4*dx4 + dy4*dy4;
   retval = (d4 < r2);
   return(retval);
}

push_queue(e)
int e;
{
  queue[qtail] = e;
  qtail = (qtail + 1) % QUEUETOP;
  edgestatus[e] = ONQUEUE;
/*
printf("#edgep %d 1 0\n",e);
click_message("edge %d pushed\n",e);
*/
}


int pop_queue()
{
  int e;
  e = queue[qhead];
  qhead = (qhead + 1) % QUEUETOP;
/*
printf("#edgep %d 3 0\n",e);
click_message("edge %d popped\n",e);
*/
  return(e);
}
