/* @copyright 1996, The Regents of the University of California
 * Compute geometric minimum spanning tree, using dumb algorithm */

#include <stdio.h>
#include <math.h>
#include "graphtool.h"

#define NUM_NODES 300
#define NUM_EDGES 300
extern int num_edges,num_nodes;
struct node *nodes=NULL;
struct edge *edges=NULL;

#define MAG2(x,y) (((x)*(x)) + ((y)*(y)))

struct setstruct
  {
      int count; 
      struct setstruct *father;
  } set[NUM_NODES];

struct nodepairstruct
  {
    int node1, node2;
    double dist2;
  } nodepair[NUM_NODES * NUM_NODES],np;

int compar();
struct setstruct *find();

int compcount =0;

main()
{
  int i,j,paircount,edgecount;
  struct setstruct *s1, *s2;
  struct nodepairstruct *pp;
  struct nodepairstruct *npp;
  
  ar_read_graph(stdin,&nodes,&edges,NUM_NODES,1,NUM_EDGES,1);
  line_buffer(stdout);

  if (num_edges != 0)
  {
    click_message("No edges allowed\n");
    goto exit99;
  }

  printf("#msg building pair structure\n");
  for (i=1,paircount=0; i <= num_nodes; i++)
    for (j=i+1; j <= num_nodes; j++)
    { 
      npp = &nodepair[paircount++];
      npp->node1 = i;
      npp->node2 = j;
    }
  printf("#msg sorting\n");
  qsort(nodepair,paircount,sizeof(np),compar);

  printf("#msg building EMST\n");
  for (i=1; i <= num_nodes; i++)
  {
    set[i].count = 1;
    set[i].father = 0;
  }
  for (edgecount = 0, i=0; (i < paircount) && (edgecount < num_nodes - 1); i++)
  {
     pp = &nodepair[i];
     if ((s1 = find(&set[pp->node1])) != (s2 = find(&set[pp->node2])))
     {
        merge(s1,s2);
        printf("#edge+ %d %d %d 1 1 -1\n",
               ++edgecount,pp->node1,pp->node2); 
     }
  }
  click_message(
    "nodes = %d, potential edges = %d, highest edge = %d, comps = %d\n",
    num_nodes, num_nodes*(num_nodes-1)/2, i,compcount);
  
exit99:;
  flush_pipe();
}

struct setstruct *find(s)
struct setstruct *s;
{
   while (s->father != 0) s = s->father;
   return(s);
}

merge(s1,s2)
struct setstruct *s1, *s2;
{
   if (s1->count >= s2->count)
   {
      s2->father = s1;
      s1->count = s1->count + s2->count;
   }
   else
   {
      s1->father = s2;
      s2->count = s1->count + s2->count;
   }
}

int compar(p1,p2)
struct nodepairstruct *p1,*p2;
{
   double d1, d2;
   d1 = MAG2((nodes[p1->node1].x - nodes[p1->node2].x),
             (nodes[p1->node1].y - nodes[p1->node2].y));
   d2 = MAG2((nodes[p2->node1].x - nodes[p2->node2].x),
             (nodes[p2->node1].y - nodes[p2->node2].y));
   compcount++;
   return((d1 > d2)?1:((d1 < d2)?-1:0));
}
