/* @copyright 1996, The Regents of the University of California */
#ifndef M_PI
#define M_PI 3.1415926535
#endif

#define VERSION 100

#define line_buffer(fp) setvbuf(fp,NULL,_IOLBF,BUFSIZ)
#ifdef STARDENT
#define ARGS(x) x
#elif __GNUC__
#define ARGS(x) x
#else
#define ARGS(x) ()
#endif
  
struct node;

struct edge {
  struct edge *from_next,*from_prev;
  struct edge *to_next,*to_prev;
  int num;
  int i_from,i_to;
  struct node *p_from,*p_to;
  double weight;
  int width,style;
  double from_angle,to_angle;
  double doublep[3];
  int inte[3];
  char string[3][26];
  void *data;
};

struct node {
  struct node *next,*prev;
  int num;
  struct edge *vh,*vt;
  double x,y,weight;
  int pattern;
  double doublep[3];
  int inte[3];
  char string[3][26];
  void *data;
};

/*
  Vertex edge list handling macros
  */
#define OPP_VERTIP(e,v) ((e)->i_from==(v) ? (e)->p_to : (e)->p_from)
#define OPP_VERTPP(e,v) ((e)->p_from==(v) ? (e)->p_to : (e)->p_from)
#define OPP_VERTPI(e,v) ((e)->p_from==(v) ? (e)->i_to : (e)->i_from)
#define OPP_VERTII(e,v) ((e)->i_from==(v) ? (e)->i_to : (e)->i_from)
#define SUCCPP(e,v) ((e)->p_from==(v) ? (e)->from_next : (e)->to_next)
#define SUCCIP(e,v) ((e)->i_from==(v) ? (e)->from_next : (e)->to_next)
#define PREDPP(e,v) ((e)->p_from==(v) ? (e)->from_prev : (e)->to_prev)
#define PREDIP(e,v) ((e)->i_from==(v) ? (e)->from_prev : (e)->to_prev)
#define CCWPP(e,v) ((e)->p_from==(v) ? (e)->from_next : (e)->to_next)
#define CCWIP(e,v) ((e)->i_from==(v) ? (e)->from_next : (e)->to_next)
#define CCWPI(e,v) ((e)->p_from==(v) ? (e)->from_next->num : (e)->to_next->num)
#define CCWII(e,v) ((e)->i_from==(v) ? (e)->from_next->num : (e)->to_next->num)
#define CWPP(e,v) ((e)->p_from==(v) ? (e)->from_prev : (e)->to_prev)
#define CWIP(e,v) ((e)->i_from==(v) ? (e)->from_prev : (e)->to_prev)
#define CWPI(e,v) ((e)->p_from==(v) ? (e)->from_prev->num : (e)->to_prev->num)
#define CWII(e,v) ((e)->i_from==(v) ? (e)->from_prev->num : (e)->to_prev->num)
#define ENUM(e) ((e)==NULL ? -1 : (e)->num)
#define ANGLEP(e,v) ((e)->p_from==(v) ? (e)->from_angle : (e)->to_angle)
#define ANGLEI(e,v) ((e)->i_from==(v) ? (e)->from_angle : (e)->to_angle)

void fill_node ARGS((struct node *,int,double,double,double,int, double *,
		     int *, char **));
void fill_edge ARGS((struct edge *,int,struct node *,int,int,double,int,int,
		     double *, int *, char **));
struct node *node_num_ptr ARGS((struct node *,int));
struct edge *edge_num_ptr ARGS((struct edge *,int));
void read_graph ARGS((char *,FILE *,FILE *,void (*)(),void (*)(),int));
void skip_graph ARGS((FILE *fp));
void ll_read_graph ARGS((FILE *,struct node **,struct edge **));
void ar_read_graph ARGS((FILE *,struct node **,struct edge **,int,int,
			 int,int));
void edge_chk_end ARGS((struct node *,struct edge *));
void new_vertex_edge ARGS((struct node *,struct node *,struct edge *));
void new_vertex_edge_lists ARGS((struct edge *));
void vertex_edge ARGS((struct node *,struct node *,struct edge *));
void vertex_edge_lists ARGS((struct edge *));
void sort_vertex_edge_lists ARGS((struct node *));
void edge_weight_matrix ARGS((struct edge *,double **,int,int,double,int));
void message();
int click_message();
void flush_pipe();
void write_graph ARGS((FILE *,int,struct node *,struct edge *));
void number_from ARGS((struct node *,int,struct edge *,int));
void free_edge_list ARGS((struct edge *));
void free_node_list ARGS((struct node *));
