/* @copyright 1996, The Regents of the University of California
 * Check for Hamiltonian cycle, using slightly improved brute force algorithm */


#include <stdio.h>
#include <math.h>
#include "graphtool.h"
 
#define NUM_NODES 300
#define NUM_EDGES 300
 
int oncycle[NUM_NODES],mark[NUM_NODES],conntests,conncount;
struct node *node_stack[NUM_NODES];
struct edge *edge_stack[NUM_NODES];
int depth = 1,iterations=0;

extern int num_edges,num_nodes,directed;
struct node *nodes=NULL;
struct edge *edges=NULL;
 
main()
{
 
  int i,found;
  char str[80];

  ar_read_graph(stdin,&nodes,&edges,NUM_NODES,1,NUM_EDGES,1);
  line_buffer(stdout);
  vertex_edge_lists(edges+1);

  click_message("num_nodes = %d\n",num_nodes);

  found = tryham();
  if (!found) 
    click_message("Graph is not Hamiltonian! %d iterations\n",iterations);
  else
  {
    for (i=1; i<= num_nodes; i++)
      printf("#edgep %d 5 -1\n",edge_stack[i]->num);
    click_message("Hamiltonian cycle found! %d iterations\n",iterations);
  }
  flush_pipe();
}

#define PUSH 1
#define NEXT 2
#define TRY 3
#define POP 4

int tryham()
{
  struct edge *edge;
  struct node *vertex;
  int nextop,xn;
  node_stack[1] = &nodes[1];
  oncycle[1] = 1;
  printf("#nodep 1 -1\n"); 
  edge = nodes[1].vh;
  nextop = TRY;
  while (1)
  {
    if (++iterations%10000 == 0) printf("#msg iterations: %d\n",iterations);
    switch(nextop)
    {
      case PUSH:
        edge_stack[depth] = edge;
         /* printf("#edgep %d 3 1 \n",edge->num); /*debug*/
        if (depth == num_nodes) return (1);
        depth = depth + 1;
         /* printf("#nodep %d -1\n",vertex->num); /*debug*/
         /* click_message("edge %d, node %d pushed\n",edge->num,vertex->num);  /*debug*/
        node_stack[depth] = vertex;
        oncycle[vertex->num] = 1;
        if ((depth > num_nodes -3) || rem_connected())
        {
          edge = vertex->vh;
          nextop = TRY;
        }
        else nextop = POP;
        break;
      case TRY:
        if (edge == NULL) nextop = POP;
        else
        {
          vertex = OPP_VERTPP(edge,node_stack[depth]);
          if (depth < num_nodes)
            nextop = (oncycle[vertex->num]) ? NEXT : PUSH;
          else
            nextop = (vertex->num==1)? PUSH: NEXT;
        }
        break;
      case NEXT:
        edge = SUCCPP(edge,node_stack[depth]);
        nextop = TRY;
        break;
      case POP:
        oncycle[xn=node_stack[depth]->num] = 0;
         /* printf("#nodep %d -2\n",xn); /*debug*/
        depth = depth - 1;
        if (depth == 0) return (0);
        edge = edge_stack[depth];
         /* printf("#edgep %d 1 -1 \n",edge->num); /*debug*/
        /* click_message("edge %d, node %d pushed\n",edge->num,xn); /*debug*/
        nextop = NEXT;
    }
  }
}

/* rem_connected: verify that subgraph induced by 
   nodes not currently on cycle: 
     (1) is connected
     (2) contains some node adjacent to node 1
     (3) has only nodes of degree >= 2.
  This prunes the search, since if this test fails, the 
  current path cannot be completed to a Hamiltonian cycle */
int rem_connected()
{
  int r,i;
  conntests++;
  conncount = 0;
  for (i=2; (i <= num_nodes) && oncycle[i]; i++);
  r = visit(&nodes[i]);
  r = r && (conncount == num_nodes - depth+1);
  /* click_message("rem_connected: conncount =%d, r = %d\n",conncount,r); /*debug*/
  /* for (i=2; i <= num_nodes; i++) /*debug*/
    /* if (!oncycle[i]) /*debug*/
      /* printf("#nodep %d -2\n",i); /*debug*/
  /* printf("#nodep 1 -2\n",i); /*debug*/
  return(r);
}

int visit(node)
struct node *node;
{
  struct edge *edge,*startedge;
  struct node *nextnode;
  int deg = 0;
  if (mark[node->num] == conntests) return;
  mark[node->num] = conntests;
  /* printf("#nodep %d 2\n",node->num); /*debug*/
  conncount++;
  if (node->num == 1) return(1);
  for (edge=startedge=node->vh; edge != NULL; )
  {
    nextnode = (OPP_VERTPP(edge,node));
    if ((nextnode->num == 1) || !oncycle[nextnode->num]) 
    {
      if (!visit(nextnode)) return(0);
      deg++;
    }
    else if (nextnode ==node_stack[depth]) deg++;
    edge = SUCCPP(edge,node);
    if (edge == startedge) edge = NULL;
  }
  return(deg > 1);
}
