/* @copyright 1996, The Regents of the University of California
   Compute shortest weighted cycle in an undirected graph that is
   not the boundary of a face.  
   Algorithm used is such that triangle inequality need
   not hold (although in this case it does), but all weights must be 
   positive */

#include <stdio.h>
#include <math.h>
#include "graphtool.h"

#define NUM_NODES 300
#define NUM_EDGES 300

#define BIGVAL 10.e10

struct heapentry
{
   int v;
} vheap[NUM_NODES];

struct vertstruct
{
   int heaploc;  /* 0 if not on heap */
   int backptr;  /* for reconstructing path */
   double weight;
} vdata[NUM_NODES];

int shortcycle[NUM_NODES];
double shortcycleweight;
int shortcyclelength;

int heapcount = 0;
char str[200];

extern int num_edges,num_nodes,directed;
struct node *nodes=NULL;
struct edge *edges=NULL;


main()
{
  int i, j, e;
  int list1[NUM_EDGES], list2[NUM_EDGES];
  int count1, count2;
  
  ar_read_graph(stdin,&nodes,&edges,NUM_NODES,1,NUM_EDGES,1);
  line_buffer(stdout);

  vertex_edge_lists(edges+1);
  sort_vertex_edge_lists(nodes+1);

  shortcycleweight = BIGVAL;
  for (e=1; e <= num_edges; e++)
  {
    printf("#msg processing edge %d\n",e);
    build_avoid_lists(e,list1,&count1,list2,&count2);
    for (i=0; i < count1; i++)
      for (j=0; j < count2; j++)
      {
        if (((i==0) && (j == 0)) || 
            ((i==count1-1) && (j == count2-1))) /*noop */{}
        else shortest_constrained_cycle(e,list1[i],list2[j]);
      }
  }
  for (i=0; i < shortcyclelength; i++)
    printf("#edgep %d 5 -1\n",shortcycle[i]);
  click_message("shortest cycle = %lf, length = %d\n",shortcycleweight,
    shortcyclelength);
  flush_pipe();
}

build_avoid_lists(e,list1,count1,list2,count2)
int e;
int list1[],list2[];
int *count1, *count2;
{
  int e1,v1,i;
  struct edge *edge;
#if 0
printf("#edgep %d 5 3\n",e);
click_message("build_avoid_lists, e = %d\n",e);
#endif
  *count1 = *count2 = 0;
  e1 = e;
  edge = &edges[e1];
  v1 = edges[e].i_to;
  e1 = CCWII(edge,v1);
  while (e1 != e)
  {
#if 0
printf("#edgep %d 5 -1\n",e1);
click_message("placing edge %d on list 1\n",e1);
#endif
    list1[(*count1)++] = e1;
    edge = &edges[e1];
    v1 = OPP_VERTII(edge,v1);
    e1 = CCWII(edge,v1);
  }

  e1 = e;
  edge = &edges[e1];
  v1 = edges[e].i_to;
  e1 = CWII(edge,v1);
  while (e1 != e)
  {
#if 0
printf("#edgep %d 5 -1\n",e1);
click_message("placing edge %d on list 2\n",e1);
#endif
    list2[(*count2)++] = e1;
    edge = &edges[e1];
    v1 = OPP_VERTII(edge,v1);
    e1 = CWII(edge,v1);
  }
#if 0
for (i=0; i < *count1; i++) printf("#edgep %d 1 -1 \n",list1[i]);
for (i=0; i < *count2; i++) printf("#edgep %d 1 -1 \n",list2[i]);
printf("#edgep %d 1 -1 \n",e);
click_message("leaving build_avoid_lists, e = %d\n",e);
#endif

}

/* shortest cycle from one endpoint of cycleedge to the other,
   avoiding the two edges avoid1 and avoid2 */
shortest_constrained_cycle(cycleedge,avoid1, avoid2)
int cycleedge, avoid1, avoid2;
{
  int source, target,e,v,w,starte;
  struct edge *edge;
  double tweight;
#if 0
printf("#edgep %d 5 3\n",cycleedge);
printf("#edgep %d 5 -1\n",avoid1);
printf("#edgep %d 5 -1\n",avoid2);
click_message("entering shortest_constrained_cycle %d %d %d\n",
cycleedge,avoid1,avoid2);
#endif
  initializeheap();
  source = edges[cycleedge].i_from;
  target = edges[cycleedge].i_to;
  vdata[source].weight = 0.0;
  insertheap(source);
  verifyheap();
  while(heapcount > 0)
  {
    v = vheap[1].v;
    if (v == target) break;
    if (vdata[v].weight + edges[cycleedge].weight > shortcycleweight) return;
    siftdown(vheap[heapcount--].v);
    verifyheap();
    e = starte = nodes[v].vh->num;
    while (e != 0)
    {
      edge = &edges[e];
      if ((e != cycleedge) && (e != avoid1) && (e != avoid2))
      {
        w = OPP_VERTII(edge,v);
        if ((vdata[w].backptr == 0) || (vdata[w].heaploc != 0))
          process_node(w,v,e);
        verifyheap();
      }
      edge = SUCCIP(edge,v);
      e = (edge == NULL) ? 0: edge->num;
      if (e == starte) e = 0;
    }
  }
  if (heapcount == 0) 
  {
#if 0
    printf("#edgep %d 5 3\n",cycleedge);
    printf("#edgep %d 5 -1\n",avoid1);
    printf("#edgep %d 5 -1\n",avoid2);
    click_message("no path from source to target\n");
    printf("#edgep %d 1 -1\n",cycleedge);
    printf("#edgep %d 1 -1\n",avoid1);
    printf("#edgep %d 1 -1\n",avoid2);
#endif
    return;
  }
  else
  {
    tweight = vdata[target].weight + edges[cycleedge].weight;
    if (tweight < shortcycleweight)
    {
      shortcycleweight = tweight;
      shortcyclelength = 0;
      shortcycle[shortcyclelength++] = cycleedge;
      while (v != source)
      {
        e = vdata[v].backptr;
        shortcycle[shortcyclelength++] = e;
        edge = &edges[e];
        v = OPP_VERTII(edge,v);
      }
    }
  }
#if 0
printf("#edgep %d 1 -1\n",cycleedge);
printf("#edgep %d 1 -1\n",avoid1);
printf("#edgep %d 1 -1\n",avoid2);
click_message("leaving shortest_constrained_cycle\n");
#endif
}

process_node(v,pred,e)
int v,pred,e;
{
  double weight;
  if ((weight = vdata[pred].weight + edges[e].weight) < vdata[v].weight)
  {
    vdata[v].backptr = e;
    vdata[v].weight = weight;
    if (vdata[v].heaploc == 0) insertheap(v);
    else siftup(v,vdata[v].heaploc);
  }
}

initializeheap()
{
  int i;
  struct vertstruct *vp;
  heapcount = 0;
  for (i=1; i <= num_nodes; i++)
  {
    vp = &vdata[i];
    vp->heaploc = vp->backptr = 0;
    vp->weight = BIGVAL;
  }
}

insertheap(v)
int v;
{
  int loc;
  loc = ++heapcount;
  siftup(v,loc);
}

siftup(v,loc)
int v;
int loc;
{
  double weight;
  int parent;
  char str[100];
  weight = vdata[v].weight;
  parent = loc/2;
  while((loc > 1) && (weight < vdata[vheap[parent].v].weight))
  {
    vheap[loc].v = vheap[parent].v;
    vdata[vheap[loc].v].heaploc = loc;
    loc = parent;
    parent = loc/2;
  }
  vheap[loc].v = v;
  vdata[v].heaploc = loc;
}

siftdown(v)
int v;
{
  int loc,child;
  double weight;
  weight = vdata[v].weight;
  loc = 1;
  child = 2 * loc;
  while(child <= heapcount)
  {
    child = ((child < heapcount) && 
             (vdata[vheap[child+1].v].weight < vdata[vheap[child].v].weight))?
            child+1 : child;
    if (weight < vdata[vheap[child].v].weight) break;
    vheap[loc].v = vheap[child].v;
    vdata[vheap[loc].v].heaploc = loc;
    loc = child;
    child = 2 * loc;
  }
  vheap[loc].v = v;
  vdata[vheap[loc].v].heaploc = loc;
}

verifyheap()
{
  int i,j;
  double vi, vj;
  for (i=1; i <= heapcount; i++)
    if (vdata[vheap[i].v].heaploc != i)
    {
     click_message("heap loc error: %d %d %d\n",
       i,vheap[i].v,vdata[vheap[i].v].heaploc);
     exit();
    }
  for (i=1, j=2; j <= heapcount; i++, j++)
  {
    vi = vdata[vheap[i].v].weight;
    vj = vdata[vheap[j].v].weight;
    if (vj < vi) goto error;
    if (j == heapcount) break;
    j++;
    vj = vdata[vheap[j].v].weight;
    if (vj < vi) goto error;
    continue;
  error:;
    click_message("heap value error: %d %d %lf %lf\n",i,j,vi,vj);
    exit();
  }
}
