/* @copyright 1996, The Regents of the University of California
   Compute shortest (Euclidean) path in an undirected graph.  
   Algorithm used is such that triangle inequality need
   not hold (although in this case it does), but all weights must be 
   positive */

#include <stdio.h>
#include <math.h>
#include "graphtool.h"

#define NUM_NODES 300
#define NUM_EDGES 300

#define BIGVAL 10.e10

double distance();
double angle();

struct heapentry
{
   int v;
} vheap[NUM_NODES];

struct vertstruct
{
   int heaploc;  /* 0 if not on heap */
   int backptr;  /* for reconstructing path */
   double dist;
} vdata[NUM_NODES];

int heapcount = 0;
char str[200];

extern int num_edges,num_nodes,directed;
struct node *nodes=NULL;
struct edge *edges=NULL;

verifyheap()
{
  int i,j;
  double vi, vj;
  for (i=1; i <= heapcount; i++)
    if (vdata[vheap[i].v].heaploc != i)
    {
     click_message("heap loc error: %d %d %d\n",
       i,vheap[i].v,vdata[vheap[i].v].heaploc);
     exit();
    }
  for (i=1, j=2; j <= heapcount; i++, j++)
  {
    vi = vdata[vheap[i].v].dist;
    vj = vdata[vheap[j].v].dist;
    if (vj < vi) goto error;
    if (j == heapcount) break;
    j++;
    vj = vdata[vheap[j].v].dist;
    if (vj < vi) goto error;
    continue;
  error:;
    click_message("heap value error: %d %d %lf %lf\n",i,j,vi,vj);
    exit();
  }
}

main()
{
  int i, source, target, e, starte, v, w;
  struct vertstruct *vp;
  struct edge * edge;
  double dist,ratio,dummyd;
  double tdeparture, avgdeparture;
  int pathlength;
  int smallv,pred,pred2;
  double a,smallangle;
  
  ar_read_graph(stdin,&nodes,&edges,300,1,300,1);
  line_buffer(stdout);


  vertex_edge_lists(edges + 1);
  for (i=1; i <= num_nodes; i++)
  {
    vp = &vdata[i];
    vp->heaploc = vp->backptr = 0;
    vp->dist = BIGVAL;
  }

  printf("#msg Select the source node\n");
  printf("#select-n\n");
  scanf("%s %d %lf %lf %lf %d",str,&source,&dummyd,&dummyd,&dummyd,&i);
  printf("#msg Select the target node\n");
  printf("#select-n\n");
  scanf("%s %d %lf %lf %lf %d",str,&target,&dummyd,&dummyd,&dummyd,&i);
  printf("#nodep %d -1\n",source);
  printf("#nodep %d -1\n",target);
/* click_message("Nodes selected!\n"); */

  vdata[source].dist = 0.0;
  insertheap(source);
  verifyheap();
  while(heapcount > 0)
  {
    v = vheap[1].v;
    if (v == target) break;
    siftdown(vheap[heapcount--].v);
    verifyheap();
    e = starte = nodes[v].vh->num;
    while (e != 0)
    {
      edge = &edges[e];
      w = OPP_VERTII(edge,v);
      if ((vdata[w].backptr == 0) || (vdata[w].heaploc != 0))
        process_node(w,v,e);
      verifyheap();
      edge = SUCCIP(edge,v);
      e = (edge == NULL) ? 0: edge->num;
      if (e == starte) e = 0;
    }
  }
  if (heapcount == 0) click_message("no path from source to target\n");
  else
  {
    smallangle = 2 * M_PI;
    smallv = v;
    pathlength = pred2 = pred = 0;
    tdeparture = 0.0;
    while (v != source)
    {
      pathlength++;
      e = vdata[v].backptr;
      printf("#edgep %d 5 -1\n",e);
      edge = &edges[e];
      pred2 = pred;
      pred = v;
      v = OPP_VERTII(edge,v);
/*
      if (pred2 != 0)
      {
        a = angle(pred2,pred,v);
        tdeparture = tdeparture + (M_PI-a);
        if (a < smallangle)
        {
          smallv = pred;
          smallangle = a;
        }
      }
*/
    }
    dist = distance(source,target);
    ratio = (dist > 1.0e-10) ? (vdata[target].dist/dist) : (0.0);
/*
    sprintf(str,"graph dist = %lf, Eucl dist = %lf, ratio = %lf\n",
      vdata[target].dist,dist,ratio);
*/
    sprintf(str,"ratio = %lf\n", ratio);
    click_message(str);
/* MD delete for DIMACS building
    printf("#nodep %d -1\n",smallv);
    sprintf(str,"smallest angle = %lf, node = %d\n",smallangle*180/M_PI,smallv);
    click_message(str);
    tdeparture = tdeparture*180/M_PI;
    avgdeparture = (pathlength > 1)? tdeparture/pathlength-1 : 0.0;
    sprintf(str,"departure: total = %lf, average = %lf\n", tdeparture, avgdeparture);
    click_message(str);
*/
  }
  flush_pipe();
}

double angle(v1,v2,v3)
int v1,v2,v3;
{
  double x1,y1,x2,y2,x3,y3,s1,s2,dp,r,z;
  x1 = nodes[v1].x; y1 = nodes[v1].y;
  x2 = nodes[v2].x; y2 = nodes[v2].y;
  x3 = nodes[v3].x; y3 = nodes[v3].y;
  s1 = sqrt((x1-x2) * (x1-x2) +  (y1-y2) * (y1-y2));
  s2 = sqrt((x2-x3) * (x2-x3) +  (y2-y3) * (y2-y3));
  dp = (x1-x2)*(x3-x2) + (y1-y2)*(y3-y2);
  z = dp/(s1*s2);
  r = acos(z);
  return(r);
}

process_node(v,pred,e)
int v,pred,e;
{
  double dist;
  if ((dist = vdata[pred].dist + distance(v,pred)) < vdata[v].dist)
  {
    vdata[v].backptr = e;
    vdata[v].dist = dist;
    if (vdata[v].heaploc == 0) insertheap(v);
    else siftup(v,vdata[v].heaploc);
  }
}

insertheap(v)
int v;
{
  int loc;
  loc = ++heapcount;
  siftup(v,loc);
}

siftup(v,loc)
int v;
int loc;
{
  double dist;
  int parent;
  char str[100];
  dist = vdata[v].dist;
  parent = loc/2;
  while((loc > 1) && (dist < vdata[vheap[parent].v].dist))
  {
    vheap[loc].v = vheap[parent].v;
    vdata[vheap[loc].v].heaploc = loc;
    loc = parent;
    parent = loc/2;
  }
  vheap[loc].v = v;
  vdata[v].heaploc = loc;
}

siftdown(v)
int v;
{
  int loc,child;
  double dist;
  dist = vdata[v].dist;
  loc = 1;
  child = 2 * loc;
  while(child <= heapcount)
  {
    child = ((child < heapcount) && 
             (vdata[vheap[child+1].v].dist < vdata[vheap[child].v].dist))?
            child+1 : child;
    if (dist < vdata[vheap[child].v].dist) break;
    vheap[loc].v = vheap[child].v;
    vdata[vheap[loc].v].heaploc = loc;
    loc = child;
    child = 2 * loc;
  }
  vheap[loc].v = v;
  vdata[vheap[loc].v].heaploc = loc;
}

double distance(v,w)
int v,w;
{
  struct node *m,*n;
  double d;
  m = &nodes[v];
  n = &nodes[w];
  d = sqrt((m->x - n->x) * (m->x - n->x) + (m->y - n->y) * (m->y - n->y));
  return(d);
}
