/* @copyright 1996, The Regents of the University of California
 * sweeptri: Compute plane-sweep (left-to-right) triangulation */

#include <stdio.h>
#include <math.h>
#include "graphtool.h"

#define NUM_NODES 10000
#define NUM_EDGES 30000

#define BOOL int
#define FALSE 0
#define TRUE 1

extern int num_edges,num_nodes,directed;
struct node *nodes=NULL;
struct edge *edges=NULL;

int compar(struct node **a, struct node **b);
struct edge *add_edge(struct node *node1,struct node *node2,
                      struct edge *edge1,struct edge *edge2);
double turn(struct node *a,struct node *b,struct node *c);

main()
{

  int i,curn,prevn;
  char str[80];
  struct edge *edge, *firstedge, *lastupedge, *lastdownedge, *upstart, 
    *downstart, *nextedge;
  struct node *curp, *prevp, *node, *nextnode;
  struct node *heap[NUM_NODES+1];
  double oldx;

  ar_read_graph(stdin,&nodes,&edges,NUM_NODES,1,NUM_EDGES,1);
  line_buffer(stdout);

/*
  printf("#gettext <Debug file name?> <sweeptri.dbg>\n");
  gets(str);
  if (strcmp(str,"#text")) printf("#debug %s\n",str+6);
*/


  for (i=1;i<=num_nodes;i++) heap[i] = &nodes[i];

  if (num_edges != 0)
  {
    click_message("No edges allowed\n");
    quickexit();
  }

  qsort(&heap[1],num_nodes,sizeof(heap[1]),&compar);

/*
  oldx = 0;
  for (i=1; i <=num_nodes; i++)
  {
    printf("#nodep %d %d\n",heap[i]->num,-1); 
    click_message("i= %d, num = %d, x= %lf\n",i, heap[i]->num,heap[i]->x);
    if (heap[i]->x < oldx) 
      click_message("DISCREPANCY: %lf %lf\n",heap[i]->x,oldx);
    oldx = heap[i]->x;
    printf("#nodep %d %d\n",heap[i]->num,-2); 
  }
*/

  lastupedge = lastdownedge = add_edge(heap[1],heap[2],NULL,NULL);

  for (i=3; i <= num_nodes; i++)
  {
     curp = heap[i];
     curn = curp->num;
     prevp = heap[i-1];
     prevn = prevp->num;
     upstart = lastupedge;
     downstart = lastdownedge;
     firstedge = add_edge(curp,prevp,NULL,lastdownedge);
     lastdownedge = lastupedge = firstedge;
     for (node=prevp, edge = upstart; TRUE; )
     {
        nextnode = OPP_VERTPP(edge,node);
        if (turn(curp,node,nextnode) >= 0) break;
        nextedge = CCWPP(edge,nextnode);
        lastupedge = add_edge(curp,nextnode,firstedge,edge);
        node = nextnode;
        edge = nextedge;
     }
     for (node=prevp, edge = downstart; TRUE;)
     {
        nextnode = OPP_VERTPP(edge,node);
        if (turn(curp,node,nextnode) <= 0) break;
        nextedge = CWPP(edge,nextnode);
        lastdownedge = add_edge(curp,nextnode,lastdownedge,nextedge);
        node = nextnode;
        edge = nextedge;
     }
  }
  printf("#nodebug\n");
  flush_pipe();
}

quickexit()
{
  printf("#nodebug\n");
  flush_pipe();
  exit(99);
}

#define MINVAL 1.0e-10
int compar(a,b)
struct node **a, **b;
{
   double retval;
   retval = ((*a)->x) - ((*b)->x);
   if (retval > MINVAL) return(1);
   else if (retval < -MINVAL) return(-1);
   else
   {
     retval = ((*a)->y) - ((*b)->y);
     if (retval > MINVAL) return(1);
     else if (retval < -MINVAL) return(-1);
     else return(0);
   }
}

circumcircle(x1,y1,x2,y2,x3,y3)
double x1,x2,x3,y1,y2,y3;
{
   double x,y,mpx1,mpx2,mpy1,mpy2,s1,s2,r,sqrt(),dx,dy;

   mpx1=(x1+x2)/2;
   mpy1=(y1+y2)/2;
   mpx2=(x2+x3)/2;
   mpy2=(y2+y3)/2;
   s1= -(x1-x2)/(y1-y2);
   s2= -(x3-x2)/(y3-y2);
   x=(s1*mpx1-s2*mpx2+mpy2-mpy1)/(s1-s2);
   y=s1*x-s1*mpx1+mpy1;
   dx=x1-x;
   dy=y1-y;
   r=sqrt(dx*dx+dy*dy);
   printf("#circle %lf %lf %lf 0\n",x,y,r);
}

struct edge *add_edge(node1,node2,edge1,edge2)
struct node *node1,*node2;
struct edge *edge1, *edge2;
{
  struct edge *edge;
  int e;
  if (num_edges >= NUM_EDGES - 1)
  { 
    click_message("**Edge overflow!\n");
    exit(99);
  } 
  edge = &edges[e = ++num_edges];
  edge->p_from = node1;
  edge->i_from = node1->num;
  edge->p_to = node2;
  edge->i_to = node2->num;
  edge->num = num_edges;
  edge->width = 1;
  edge->weight = 1;
  edge->style = -1;
  link(edge,node1,edge1,TRUE);
  link(edge,node2,edge2,FALSE);
  printf("#edge+ %d %d %d 1 1 -1\n",e,node1->num,node2->num);
  return(edge);
}

link(edge,node,pred,from)
/* link edge into edges incident on node; pred is its predecessor (i.e.,
   its clockwise neighbor) */
struct edge *edge, *pred;
struct node *node;
BOOL from;
{
  struct edge *e;
  if (node->vh == NULL)
  {
    node->vh = node->vt = edge;
    if (from) edge->from_next = edge->from_prev = edge;
    else edge->to_next = edge->to_prev = edge;
  }
  else
  {
    e = CCWPP(pred,node);
    if (from)
    {
      edge->from_next = e;
      edge->from_prev = pred;
    }
    else
    {
      edge->to_next = e;
      edge->to_prev = pred;
    }
    if (pred->p_from == node) pred->from_next = edge;
    else pred->to_next = edge;
    if (e->p_from == node) e->from_prev = edge;
    else e->to_prev = edge;
  }
}

double turn(a,b,c)
/* return +, 0, - as abc is left turn, straight, right turn */
struct node *a, *b, *c;
{
    double ax,ay,bx,by,cx,cy,dot;
    ax = a->x;  ay = a->y;
    bx = b->x;  by = b->y;
    cx = c->x;  cy = c->y;
    dot = (ay - by) * (cx - ax) + (bx - ax) * (cy - ay ); 
    return(dot);
}
