/* @copyright 1996, The Regents of the University of California
   Compute Voronoi diagram, by first computing Delaunay triangulation, 
   using simple O(N**2) algorithm due to (I think) McLain, and then
   taking dual */

#include <stdio.h>
#include <math.h>
#include <strings.h>
#include "graphtool.h"

#define NUM_NODES 900
#define NUM_EDGES 900

double pseudoangle();
int edgestack[NUM_EDGES];
int depth = 0;
int hullcount;
int disptri = 0;  /* whether to display triangulation! */
#define SMALLVAL -1.0e10

struct node *nodes=NULL;
struct edge *edges=NULL;
extern int num_nodes,num_edges;

int vornode_base, voredge_base;
int faceindex[NUM_EDGES][2];

void circumcenter ARGS((int,int,int,double *, double *));

main(argc,argv)
int argc;
char **argv;
{
  int i;
  char str[80];

  for (i=0; i <NUM_EDGES; i++) faceindex[i][0] = faceindex[i][1] = 0;
  ar_read_graph(stdin,&nodes,&edges,NUM_NODES,1,NUM_EDGES,1);
  line_buffer(stdout);
/* printf("#gettext <Debug file name?> <gtool.dbg>\n"); /*debug*/
/*  click_message("argc = %d\n"); /*debug*/
/*  for (i=0; i < argc; i++) click_message("%d: %s\n",i,argv[i]);/*debug*/
  if (strcmp(argv[0],"Delaunay Voronoi overlay") == 0)
    disptri = 1;
  else disptri = 0;
  /* gets(str); /*debug*/
  /* if (strcmp(str,"#text")) printf("#debug %s\n",str+6); /*debug*/

  for (i=1;i<=num_nodes;i++) nodes[i].vh=NULL;

  if (num_edges != 0)
  {
    click_message("No edges allowed\n");
    goto exit99;
  }
  printf("#msg computing convex hull\n");
  hull();
  hullcount = num_edges;
  printf("#msg computing Delaunay triangulation\n");
  tri();
  vornode_base = num_nodes+1;
  voredge_base = num_edges+1;
  printf("#msg computing Voronoi diagram\n");
  vordia();

exit99:;
  printf("mesg all done!\n");
  flush_pipe();
}

hull()
{
  int i,k,bestpt,minx,e;
  char str[80];
  double x1,x2,y1,y2,bestval,newval;
  
  for (minx = 1,i=2; i <= num_nodes; i++)
     if (nodes[i].x < nodes[minx].x) minx = i;
  for (k=minx,x1=nodes[minx].x,y1=nodes[minx].y-1;;)
  {
    x2 = nodes[k].x;
    y2 = nodes[k].y;
    bestpt = (k==1)?2:1;
    bestval = pseudoangle(x1,y1,x2,y2,nodes[bestpt].x,nodes[bestpt].y);
    i = bestpt + 1;
    for (; i <= num_nodes; i++)
    {
      if (i == k) goto cont;
      newval = pseudoangle(x1,y1,x2,y2,nodes[i].x,nodes[i].y);
      if (newval > bestval)
      {
        bestval = newval;
        bestpt = i;
      }
  cont:;
    }
    e = addedge(k,bestpt);
    faceindex[e][0] = -1;
    pushedge(e);
    k = bestpt;
    x1 = x2;
    y1 = y2;
    if (k==minx) return;
  }
}

tri()
{
  int poppededge,e,f,t,besti,i;
  double x1,x2,x3,y1,y2,y3,bestval,nx,ny,newval;
  while (depth>0)
  {
    poppededge = popedge();
    f = edges[poppededge].i_from;
    t = edges[poppededge].i_to;
    /* printf("#edgep %d 5 3\n",poppededge);
       printf("#nodep %d -1\n",f); 
       printf("#nodep %d 3\n",t); */
    x1 = nodes[f].x; y1 = nodes[f].y;
    x3 = nodes[t].x; y3 = nodes[t].y;
    nx = y3 - y1;
    ny = x1 - x3;
    bestval = SMALLVAL;
    besti = 0;
    for (i=1; i <= num_nodes; i++)
    {
       if ((i==f) || (i==t)) continue;
       x2 = nodes[i].x;
       y2 = nodes[i].y;
       if ((x2-x1)*nx + (y2-y1)*ny <= 0) continue;
       newval = pseudoangle(x1,y1,x2,y2,x3,y3);
       if (newval > bestval)
       {
         bestval = newval;
         besti = i;
       }
    }
    if (besti == 0) goto cont;
    /* checkcirc(f,t,besti,poppededge); */
    if (findedge(f,besti) == 0)
    {
       e = addedge(f,besti);
       pushedge(e);
    }
    if (findedge(besti,t) == 0)
    {
       e = addedge(besti,t);
       pushedge(e);
    }
  cont:;
    /* printf("#nodep %d -2\n",f); 
       printf("#nodep %d -2\n",t); 
       printf("#edgep %d 1 -1\n",poppededge); */
  }
}

vordia()
{
  int cv[3],i,j,newv,v,k,e,f,t;
  struct edge *edge;
  struct node *node;
  double dx,dy,s,newx,newy;
  if (2*num_edges >= NUM_EDGES)
  {
    click_message("edge overflow in Voronoi diagram\n");
    return;
  }
  if (3*num_nodes >= NUM_NODES)
  {
    click_message("vertex overflow in Voronoi diagram\n");
    return;
  }
  sort_vertex_edge_lists(&nodes[1]);
  for (i=1; i< voredge_base; i++)
    for (j=0; j <= 1; j++)
    {
      if (faceindex[i][j] == 0)
      {
        newv = ++num_nodes;
        node = &nodes[newv];
        edge = &edges[i];
        v = (j==0)? edge->i_from : edge->i_to;
        for (k=0,e=i; e != 0; k++)
        {
          /* printf("#nodep %d 4\n",v); /*debug*/
         /* printf("#edgep %d 5 3\n",e); /*debug*/
         /* click_message("v=%d\n",v); /*debug*/
         /* printf("#edgep %d 2 -1\n",e); /*debug*/
           if (k < 3) cv[k] = v;
           if (edge->i_from == v) faceindex[e][0] = newv;
           else faceindex[e][1] = newv;
           v = OPP_VERTII(edge,v);
           edge = CWIP(edge,v);
           e = (edge == NULL)? 0 : edge->num;
           if (e == i) e = 0;
        }
        circumcenter(cv[0],cv[1],cv[2],&node->x,&node->y);
        /* click_message("#msg triang %d %d %d\n",cv[0],cv[1],cv[2]); /*debug*/
        /* click_message("node %d\n",newv); /*debug */
        printf("#node+ %d %lf %lf %lf -1\n",newv,node->x,node->y,1.0);
         /* click_message("node added\n"); /*debug*/
         /*  printf("#nodep %d -2\n",cv[0]);  /*debug*/
         /*  printf("#nodep %d -2\n",cv[1]);  /*debug*/
         /*  printf("#nodep %d -2\n",cv[2]);  /*debug*/
      }
    }
  /* click_message("circumcenters added\n"); /*debug*/
  for (i=1; i< voredge_base; i++)
     if ((faceindex[i][0] > 0) && (faceindex[i][1] > 0))
        printf("#edge+ %d %d %d 1 3 3\n",++num_edges,
               faceindex[i][0],faceindex[i][1]);
  /* click_message("dual edges added\n"); /*debug*/
  for (i=1; i< voredge_base; i++)
    for (j=0; j <= 1; j++)
      if (faceindex[i][j] == -1)
      {
        if (j==0)
        {
           f = edges[i].i_from;
           t = edges[i].i_to;
        }
        else 
        {
           f = edges[i].i_to;
           t = edges[i].i_from;
        }
        /* printf("#edgep %d 3 -1\n",i); */
        /* printf("#nodep %d 3\n",f); */
        /* printf("#nodep %d -1\n",t); */
        /* click_message("i,j,f,t = %d %d %d %d\n",i,j,f,t);*/
        /* printf("#edgep %d 1 -1\n",i);*/
        /* printf("#nodep %d -2\n",f); */
        /* printf("#nodep %d -2\n",t); */
        dx = nodes[f].y - nodes[t].y;
        dy = nodes[t].x - nodes[f].x;
        s = hypot(dx,dy);
        v = faceindex[i][1-j];
        /* printf("#nodep %d 3\n",v); */
        /* click_message("v = %d\n",v);*/
        /* printf("#nodep %d -1\n",v); */
        newx = nodes[v].x + dx * 1000.0/s;
        newy = nodes[v].y + dy * 1000.0/s;
        newv = ++num_nodes;
        printf("#node+ %d %lf %lf %lf -2\n",newv,newx,newy,1.0);
        printf("#edge+ %d %d %d 1 3 3\n",++num_edges,faceindex[i][1-j],newv);
      }
   /* click_message("radial edges added\n"); /*debug*/
}

void circumcenter(v1,v2,v3,centx,centy)
int v1,v2,v3;
double *centx,*centy;
{
  double x1,y1,x2,y2,x3,y3,mx12,my12,mx13,my13,a12,b12,c12,a13,b13,c13;
  x1 = nodes[v1].x; y1 = nodes[v1].y;
  x2 = nodes[v2].x; y2 = nodes[v2].y;
  x3 = nodes[v3].x; y3 = nodes[v3].y;
  mx12 = (x1 + x2)/2;  my12 = (y1 + y2)/2;
  a12 = x1 - x2;  b12 = y1 - y2; c12 = a12 * mx12 + b12 * my12;
  mx13 = (x1 + x3)/2;  my13 = (y1 + y3)/2;
  a13 = x1 - x3;  b13 = y1 - y3; c13 = a13 * mx13 + b13 * my13;
  *centx = (c12 * b13 - c13 * b12)/(a12 * b13 -a13 * b12);
  *centy = (a12 * c13 - a13 * c12)/(a12 * b13 -a13 * b12);
}

checkcirc(v1,v2,v3,e)
int v1,v2,v3,e;
{
  double x1,y1,x2,y2,x3,y3,mpx1,mpx2,mpy1,mpy2,s1,s2,centx,centy,dx,dy,x,y,r,r2;
  int i;
  x1 = nodes[v1].x; y1 = nodes[v1].y;
  x2 = nodes[v2].x; y2 = nodes[v2].y;
  x3 = nodes[v3].x; y3 = nodes[v3].y;
  mpx1=(x1+x2)/2;
  mpy1=(y1+y2)/2;
  mpx2=(x2+x3)/2;
  mpy2=(y2+y3)/2;
  s1= -(x1-x2)/(y1-y2);
  s2= -(x3-x2)/(y3-y2);
  centx=(s1*mpx1-s2*mpx2+mpy2-mpy1)/(s1-s2);
  centy=s1*centx-s1*mpx1+mpy1;
  dx=x1-centx;
  dy=y1-centy;
  r2=dx*dx+dy*dy;
  r = sqrt(r2);
  printf("#circle %lf %lf %lf 0\n",centx,centy,r);
  printf("#redraw\n");
  for (i=1; i <= num_nodes; i++)
  {
    if ((i==v1) || (i == v2) || (i == v3)) continue;
    x = nodes[i].x; y = nodes[i].y;
    if ((x-centx) * (x-centx) + (y-centy) * (y-centy) < r2)
    {
      click_message("Anomaly: %d %d %d %d \n",v1,v2,v3,i);
      printf("#nodep %d -1\n",v1); 
      printf("#nodep %d -1\n",v2); 
      printf("#nodep %d -1\n",v3); 
      printf("#nodep %d 4\n",i); 
      r = sqrt(r2);
      printf("#circle %lf %lf %lf 0\n",centx,centy,r);
      printf("#edgep %d 5 3\n",e);
      click_message("Anomaly: %d %d %d %d \n",v1,v2,v3,i);
      return;
    } 
  } 
}


int addedge(f,t)
int f,t;
{
  struct edge *edge;
  struct node *node;
  int e;
  if (num_edges >= NUM_EDGES - 1)
  {
    click_message("**Edge overflow!\n");
    exit(99);
  }
  edge = &edges[e=++num_edges];
  edge->i_from = f;
  edge->i_to = t;
  edge->p_from = &nodes[f];
  edge->p_to = &nodes[t];
  edge->num = num_edges;
  edge->weight = 1;
  edge->width = 1;
  edge->style = -1;
  if (disptri) printf("#edge+ %d %d %d 1 1 -1\n",e,f,t);
  vertex_edge(&nodes[f],&nodes[t],edge);
  return(e);
}

int findedge(f,t)
int f,t;
{
  int v;
  int r = 0;
  struct edge *e;
  
 /* printf("#nodep %d -1\n",f);     */
 /* printf("#nodep %d 0\n",t);     */
   /* click_message("findedge: f,t = %d %d\n",f,t);    */

  e = nodes[f].vh;
  while (e != NULL)
  {
    v = OPP_VERTII(e,f);
  
/* printf("#edgep %d 3 -1\n",e);   */
/* printf("#nodep %d 5\n",v);    */
  /* click_message("f,t,v,e = %d %d %d %d\n",f,t,v,e);   */
/* printf("#edgep %d 1 -1\n",e);   */
/* printf("#nodep %d -2\n",v);    */
    if (v == t)
    {
       r = e->num;
       break;
    } 
    e = SUCCIP(e,f);
  }
       
   /* click_message("findedge returning %d\n",r);    */
 /* printf("#nodep %d -2\n",f);     */
 /* printf("#nodep %d -2\n",t);     */
  return(r);
}

double pseudoangle(x1,y1,x2,y2,x3,y3)
double x1,y1,x2,y2,x3,y3;
{
  double r,r1,r2,r3,sgn;
  r1 = (x3-x2)*(x2-x1) + (y3-y2)*(y2-y1);
  sgn = (r1>0)?1:-1;
  r2 = (x3-x2)*(x3-x2) + (y3-y2)*(y3-y2);
  r3 = (x2-x1)*(x2-x1) + (y2-y1)*(y2-y1);
  r = sgn*r1*r1/(r2*r3);
  return(r);
}

pushedge(e)
int e;
{
  edgestack[depth++] = e;
}

int popedge()
{
  return(edgestack[--depth]);
}
