/* @copyright 1996, The Regents of the University of California
   Compute facts about weights, including:
   (1) max edge weight
   (2) min edge weight
   (3) max face sum
   (4) min face sum
*/

#include <stdio.h>
#include <math.h>
#include "graphtool.h"

#define BOOL int
#define FALSE 0
#define TRUE 1

#define NUM_NODES 300
#define NUM_EDGES 300

#define BIGVAL 10.e10

char str[200];

extern int num_edges,num_nodes,directed;
struct node *nodes=NULL;
struct edge *edges=NULL;


main()
{
  int i, j, e, e1, v1, s, nfaces, edgesinface, emin, emax, edgesinminface,
    edgesinmaxface;
  double faceweightsum, eminweight, emaxweight, minfaceweight, maxfaceweight;
  int edge_list[NUM_EDGES], max_edge_list[NUM_EDGES], min_edge_list[NUM_EDGES];
  BOOL edge_marks[NUM_EDGES][2];
  struct edge *edge;
  
  ar_read_graph(stdin,&nodes,&edges,NUM_NODES,1,NUM_EDGES,1);
  line_buffer(stdout);

  vertex_edge_lists(edges+1);
  sort_vertex_edge_lists(nodes+1); 

/* process edges */
  emaxweight = -BIGVAL; eminweight = BIGVAL; emax = emin = 1;
  for (e=1; e <= num_edges; e++)
  {
    if (edges[e].weight < eminweight)
    {
      emin = e;
      eminweight = edges[e].weight;
    }
    if (edges[e].weight > emaxweight)
    {
      emax = e;
      emaxweight = edges[e].weight;
    }
  }
  printf("#edgep %d 5 -1\n",emin);
  click_message("min edge %d, weight = %lf\n",emin,eminweight);
  printf("#edgep %d 1 -1\n",emin);
  printf("#edgep %d 5 -1\n",emax);
  click_message("max edge %d, weight = %lf\n",emax,emaxweight);
  printf("#edgep %d 1 -1\n",emax);
/* process faces */
  maxfaceweight = -BIGVAL; minfaceweight = BIGVAL; 
  edgesinminface = edgesinmaxface = 0;
  for (e=1; e <= num_edges; e++)
    edge_marks[e][0] = edge_marks[e][1] = FALSE;
  nfaces = 0;
  for (e=1; e <= num_edges; e++)
  {
    for (j=0; j <= 1; j++)
    {
      if (!edge_marks[e][j])
      {
        nfaces++;
        edgesinface = 0;
        faceweightsum = 0;
        edge_marks[e][j] = TRUE;
        e1 = e;
        edge = &edges[e1];
        v1 = (j==0)? edges[e1].i_from : edges[e].i_to;
        v1 = OPP_VERTII(edge,v1);
        edge_list[edgesinface++] = e1;
        /* printf("#edgep %d 5 -1\n",e1); */
        faceweightsum = edge->weight;
        e1 = CCWII(edge,v1);
        while (e1 != e)
        {
          edge = &edges[e1];
          s = (edge->i_from == v1)? 0 : 1;
          edge_marks[e1][s] = TRUE;
          v1 = OPP_VERTII(edge,v1); 
          edge_list[edgesinface++] = e1;    
          /* printf("#edgep %d 5 -1\n",e1);*/
          faceweightsum = faceweightsum + edge->weight;
          e1 = CCWII(edge,v1);
        }
        /* click_message("face sum = %lf\n",faceweightsum); */
        /* for (i=0; i < edgesinface; i++) printf("#edgep %d 1 -1\n",edge_list[i]); */
        if (faceweightsum < minfaceweight)
        {
          edgesinminface = edgesinface;
          for (i=0; i < edgesinface; i++) min_edge_list[i] = edge_list[i];
          minfaceweight = faceweightsum;
        }
        if (faceweightsum > maxfaceweight)
        {
          edgesinmaxface = edgesinface;
          for (i=0; i < edgesinface; i++) max_edge_list[i] = edge_list[i];
          maxfaceweight = faceweightsum;
        }
      }
    }
  }
  for (i=0; i < edgesinminface; i++) 
    printf("#edgep %d 5 -1\n",min_edge_list[i]);
  click_message("minimum face weight: %lf\n", minfaceweight);
  for (i=0; i < edgesinminface; i++) 
    printf("#edgep %d 1 -1\n",min_edge_list[i]);
  for (i=0; i < edgesinmaxface; i++) 
    printf("#edgep %d 5 -1\n",max_edge_list[i]);
  click_message("maximum face weight: %lf\n", maxfaceweight);
  for (i=0; i < edgesinmaxface; i++) 
    printf("#edgep %d 1 -1\n",max_edge_list[i]);
  click_message("face count = %d\n",nfaces);
  flush_pipe();
}

